package ru.yandex.wmconsole.servantlet.sitemaps;

import java.io.IOException;
import java.net.URL;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.wmconsole.service.error.WMCUserProblem;
import ru.yandex.wmconsole.viewer.sitemap.SitemapService2;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;
import ru.yandex.wmtools.common.sita.SitaException;
import ru.yandex.wmtools.common.sita.SitaUrlFetchResponse;

/**
 * Поставщик данных из URL
 */
public class SitemapUrlDataProvider implements SitemapDataProvider {
    private static final Logger log = LoggerFactory.getLogger(SitemapUrlDataProvider.class);

    private final String sitemapUrl;
    private final SitemapService2 sitemapService2;

    public SitemapUrlDataProvider(String sitemapUrl, SitemapService2 sitemapService2) {
        this.sitemapUrl = sitemapUrl;
        this.sitemapService2 = sitemapService2;
    }

    @Override
    public void provideData(SitemapRequestBuilder builder) throws UserException, InternalException {
        // Пытаемся загрузить sitemap из указанного url
        log.debug("Getting sitemap from URL " + sitemapUrl + "...");
        log.debug("" + sitemapUrl + " " + AbstractServantlet.prepareUrl(sitemapUrl, true));
        final URL url = AbstractServantlet.prepareUrl(sitemapUrl, true);
        // Запрещаем добавлять главные страницы в качестве sitemap-файлов,
        // так как в роботе они отбрасываются
        SitaUrlFetchResponse sitemap;
        try {
            sitemap = sitemapService2.getAndValidateSitemap(url);
            IOUtils.copy(sitemap.getDocumentContentStream(), builder.getStream());
        } catch (IOException e) {
            log.error("Unable to download sitemap", e);
            throw new InternalException(InternalProblem.PROCESSING_ERROR, "Unable to copy sitemap content", e);
        } catch (SitaException e) {
            log.error("Unable to download sitemap", e);
            throw new UserException(WMCUserProblem.SITEMAP_ACCESS_ERROR, "Failed to load sitemap " + sitemapUrl, e);
        }
        builder.setRedirected(sitemap.getSitaRedirectInfo().hasRedirects());
    }
}
