package ru.yandex.wmconsole.servantlet.top;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.WMCTopInfo;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.TopTypeEnum;

/**
 * @author avhaliullin
 */
public class WMCCustomQueriesServantlet extends WMCAbstractQueriesInfoServantlet {
    @Override
    protected WMCTopInfo getTopInfo(Integer region, List<RegionInfo> keyRegions, HostDbHostInfo hostInfoType, Date date,
                                    OrderByClause orderBy, TopTypeEnum type, boolean includeSubregions, Pager pager) throws InternalException {
        return topInfoService.getCustomQueriesInfo(region, keyRegions, hostInfoType, date, orderBy, pager, type,
                includeSubregions);
    }

    @Override
    protected boolean isPagerNeeded() {
        return true;
    }

    @Override
    protected boolean isTopInfoTypeRequired() {
        return false;
    }

    @Override
    protected Date getLatestInfoDateIfDateIsNull(Integer region, HostDbHostInfo hostDbHostInfo, Date date, boolean includeSubRegion) throws InternalException {
        return topInfoService.getLatestCustomInfoDateIfDateIsNull(region, hostDbHostInfo, date, includeSubRegion);
    }

    @Override
    protected List<Date> getInfoDatesByHost(HostDbHostInfo hostDbHostInfo) throws InternalException {
        return getTopInfoService().getCustomInfoDatesByHost(hostDbHostInfo);
    }

    @Override
    protected Map<Date, Boolean> getInfoDatesForRegionByHost(
            final Integer region, final HostDbHostInfo hostDbHostInfo, final boolean includeSubRegion) throws InternalException {

        Map<Date, Boolean> dates = new LinkedHashMap<Date, Boolean>();
        List<Date> hostDates = getTopInfoService().getCustomInfoDatesForRegionByHost(null, hostDbHostInfo, includeSubRegion);
        for (Date d : hostDates) {
            dates.put(d, false);
        }

        List<Date> hostRegionDates = getTopInfoService().getCustomInfoDatesForRegionByHost(region, hostDbHostInfo, includeSubRegion);
        for (Date d : hostRegionDates) {
            dates.put(d, true);
        }
        return dates;
    }
}
