package ru.yandex.wmconsole.servantlet.top;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.WMCTopInfo;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.TopTypeEnum;

public class WMCTopQueriesServantlet extends WMCAbstractQueriesInfoServantlet {
    @Override
    protected WMCTopInfo getTopInfo(Integer region, List<RegionInfo> keyRegions, HostDbHostInfo hostInfoType, Date date,
            OrderByClause orderBy, TopTypeEnum type, boolean includeSubregions, Pager pager) throws InternalException {
        return topInfoService.getTopInfo(region, keyRegions, hostInfoType, date, orderBy, type, includeSubregions);
    }

    @Override
    protected boolean isPagerNeeded() {
        return false;
    }

    @Override
    protected boolean isTopInfoTypeRequired() {
        return true;
    }

    @Override
    protected Date getLatestInfoDateIfDateIsNull(Integer region, HostDbHostInfo hostDbHostInfo, Date date, boolean includeSubregions) throws InternalException {
        return topInfoService.getLatestInfoDateIfDateIsNull(region, hostDbHostInfo, date, includeSubregions);
    }

    @Override
    protected List<Date> getInfoDatesByHost(HostDbHostInfo hostDbHostInfo) throws InternalException {
        return getTopInfoService().getTopInfoDatesByHost(hostDbHostInfo);
    }

    @Override
    protected Map<Date, Boolean> getInfoDatesForRegionByHost(
            final Integer region, final HostDbHostInfo hostDbHostInfo, final boolean includeSubRegion) throws InternalException {

        Map<Date, Boolean> dates = new LinkedHashMap<Date, Boolean>();
        List<Date> hostDates = getTopInfoService().getTopInfoDatesForRegionByHost(null, hostDbHostInfo, includeSubRegion);
        for (Date d : hostDates) {
            dates.put(d, false);
        }

        List<Date> hostRegionDates = getTopInfoService().getTopInfoDatesForRegionByHost(region, hostDbHostInfo, includeSubRegion);
        for (Date d : hostRegionDates) {
            dates.put(d, true);
        }
        return dates;
    }
}
