package ru.yandex.wmconsole.servantlet.top;

import java.util.Date;
import java.util.List;
import java.util.NavigableMap;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.WMCTopInfo;
import ru.yandex.wmconsole.data.info.WMCTopInfoItem;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.servantlet.BriefHostInfoHelper;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.WMCCustomRegionService;
import ru.yandex.wmconsole.service.WMCTopInfoService;
import ru.yandex.wmtools.common.data.TopQueryHistoryTypeEnum;
import ru.yandex.wmtools.common.data.info.TotalsInfo;
import ru.yandex.wmtools.common.data.plot.DatePlotHelper;
import ru.yandex.wmtools.common.data.plot.HighchartPlotDataWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.top.WMToolsTopQueryHistoryPlotDataServantlet;

public class WMCTopQueryHistoryPlotDataServantlet
        extends WMToolsTopQueryHistoryPlotDataServantlet<HostDbHostInfo, WMCTopInfo, WMCTopInfoItem, TotalsInfo> {
    private static final String PARAM_QUERY_ID = "query_id";
    private static final String PARAM_REGION = "region";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_INCLUDE_SUBREGIONS = "include_subregions";
    private static final String PARAM_DATE = "date";

    private static final String TOP_QUERY_HISTORY_PLOT_NAME = "top_query_history";

    private BriefHostInfoHelper hostInfoHelper;
    private WMCTopInfoService topInfoService;
    private HostDbHostInfoService hostDbHostInfoService;
    private WMCCustomRegionService customRegionService;

    @Override
    protected HostDbHostInfo getHostInfoType(ServRequest req, ServResponse res, long userId) throws ClientException, InternalException {
        BriefHostInfo briefHostInfo = hostInfoHelper.getHostInfo(req, true, userId, true, true, res, true, true);

        if (briefHostInfo == null) {
            return null;
        }
        return hostDbHostInfoService.getHostDbHostInfo(briefHostInfo.getName());
    }

    @Override
    protected Long[] getParamQueryId(ServRequest req) {
        return getMultiParamLong(req, PARAM_QUERY_ID);
    }

    @Override
    protected Integer getParamRegion(ServRequest req) throws UserException {
        return getIntParam(req, PARAM_REGION);
    }

    @Override
    protected Date getParamGraphDate(ServRequest req) throws UserException {
        return getDateParam(req, PARAM_DATE);
    }

    @Override
    protected Boolean getParamIncludeSubregions(ServRequest req) {
        return getBooleanParam(req, PARAM_INCLUDE_SUBREGIONS);
    }

    @Override
    protected TopQueryHistoryTypeEnum getParamQueryHistoryType(ServRequest req) {
        return TopQueryHistoryTypeEnum.getByName(req.getParam(PARAM_TYPE, true));
    }

    @Override
    protected <T> void outputData(ServResponse res, DatePlotHelper<T> plotHelper, List<NavigableMap<Date, T>> data, List<String> labels, List<Long> queryIds) {
        res.addData(new HighchartPlotDataWrapper<Date, T>(TOP_QUERY_HISTORY_PLOT_NAME, data, labels, queryIds, plotHelper));
    }

    @Required
    public void setHostInfoHelper(BriefHostInfoHelper hostInfoHelper) {
        this.hostInfoHelper = hostInfoHelper;
    }

    @Required
    public void setTopInfoService(WMCTopInfoService topInfoService) {
        this.topInfoService = topInfoService;
    }

    @Override
    protected WMCTopInfoService getTopInfoService() {
        return topInfoService;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }

    @Required
    public void setCustomRegionService(WMCCustomRegionService customRegionService) {
        this.customRegionService = customRegionService;
    }

    @Override
    protected WMCCustomRegionService getCustomRegionService() {
        return customRegionService;
    }
}
