package ru.yandex.wmconsole.servantlet.top.queries;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.WMCTopInfoService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class AddCustomQueryServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String PARAM_QUERY = "query";

    private WMCTopInfoService topInfoService;
    private HostDbHostInfoService hostDbHostInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        String standardizedQuery = topInfoService.standardizeQuery(getRequiredStringParam(req, PARAM_QUERY));
        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(
                getHostInfoAndVerify(req, userId).getName());

        topInfoService.addCustomQueryForHost(hostDbHostInfo, standardizedQuery);
    }

    @Required
    public void setTopInfoService(WMCTopInfoService topInfoService) {
        this.topInfoService = topInfoService;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }
}
