package ru.yandex.wmconsole.servantlet.top.regions;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.WMCCustomRegionService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class AddCustomRegionServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String PARAM_REGION = "region";

    private WMCCustomRegionService customRegionService;
    private HostDbHostInfoService hostDbHostInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        int regionId = getRequiredIntParam(req, PARAM_REGION);
        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(
                getHostInfoAndVerify(req, userId).getName());

        customRegionService.addCustomRegionForHost(hostDbHostInfo, regionId);
    }

    @Required
    public void setCustomRegionService(WMCCustomRegionService customRegionService) {
        this.customRegionService = customRegionService;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }
}
