package ru.yandex.wmconsole.servantlet.top.regions;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.WMCCustomRegionService;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.data.info.RegionInfoTreeNode;
import ru.yandex.wmtools.common.data.wrappers.RegionInfoTreeNodeWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.RegionsTreeCacheService;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class CustomRegionListServantlet extends WMCAuthorizedHostOperationServantlet {
    private HostDbHostInfoService hostDbHostInfoService;
    private WMCCustomRegionService customRegionService;
    private RegionsTreeCacheService regionsTreeCacheService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(
                getHostInfoAndVerify(req, userId).getName());
        Collection<RegionInfo> customRegionInfos = customRegionService.getKeyRegionsForHost(hostDbHostInfo, false);

        List<RegionInfoTreeNode> tree = regionsTreeCacheService.getTreeWithCountries(customRegionInfos);
        res.addData(XmlConvertableCollectionWrapper.wrap(tree, RegionInfoTreeNodeWrapper.class, "custom-regions"));
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }

    @Required
    public void setCustomRegionService(WMCCustomRegionService customRegionService) {
        this.customRegionService = customRegionService;
    }

    @Required
    public void setRegionsTreeCacheService(RegionsTreeCacheService regionsTreeCacheService) {
        this.regionsTreeCacheService = regionsTreeCacheService;
    }
}
