package ru.yandex.wmconsole.servantlet.top.regions;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.WMCCustomRegionService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

public class RemoveCustomRegionServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String PARAM_REGION = "region";

    private WMCCustomRegionService customRegionService;
    private HostDbHostInfoService hostDbHostInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        List<Integer> selectedRegionIds = Arrays.asList(getMultiParamInt(req, PARAM_REGION));
        selectedRegionIds.remove(Integer.valueOf(0));

        if (selectedRegionIds.size() <= 0) {
            throw new UserException(UserProblem.REQUIRED_PARAM_MISSED, "Required parameter " + PARAM_REGION + " missed", PARAM_REGION);
        }

        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(
                getHostInfoAndVerify(req, userId).getName());

        customRegionService.removeCustomRegionsForHost(hostDbHostInfo, selectedRegionIds);
    }

    @Required
    public void setCustomRegionService(WMCCustomRegionService customRegionService) {
        this.customRegionService = customRegionService;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }
}
