package ru.yandex.wmconsole.servantlet.user.settings;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.webmaster.common.util.xml.SimpleXmlBuilder;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.UserSettingsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

import java.util.List;
import java.util.Map;

/**
 * User: azakharov
 * Date: 21.02.14
 * Time: 17:15
 */
public class GetUserSettingsServantlet extends WMCAuthenticationServantlet {

    private static final String PARAM_OPTION = "option";

    private UserSettingsService userSettingsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        final List<String> options = req.getMultiParams(PARAM_OPTION);

        final Map<String, String> settings = userSettingsService.getSettings(userId, options);
        res.addData(new UserSettingsWrapper(settings));
    }

    public static class UserSettingsWrapper implements XmlConvertable {
        private final Map<String, String> settings;

        public UserSettingsWrapper(Map<String, String> settings) {
            this.settings = settings;
        }

        @Override
        public void toXml(StringBuilder storage) {
            SimpleXmlBuilder xml = new SimpleXmlBuilder(storage);
            xml.open("settings");
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                xml.open("option");
                xml.attribute("name", entry.getKey());
                xml.text(entry.getValue());
                xml.close(); // option
            }
            xml.close(); // settings
        }
    }

    @Required
    public void setUserSettingsService(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }
}
