package ru.yandex.wmconsole.servantlet.user.settings;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.UserSettingsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: azakharov
 * Date: 21.02.14
 * Time: 17:26
 */
public class SaveUserSettingsServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_OPTION = "option";
    private static final String PARAM_VALUE = "value";

    private UserSettingsService userSettingsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        final String option = getRequiredStringParam(req, PARAM_OPTION);
        final String value = getRequiredStringParam(req, PARAM_VALUE);
        userSettingsService.saveSettings(userId, option, value);
    }

    @Required
    public void setUserSettingsService(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }
}
