package ru.yandex.wmconsole.servantlet.virus;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.viewer.service.NewWebmasterProxyService;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.RecheckInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.VirusedHostService;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class VirusRecheckServantlet extends WMCAuthenticationServantlet {

    private NewWebmasterProxyService newWebmasterProxyService;
    private VirusedHostService virusedHostService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        BriefHostInfo briefHostInfo = getHostInfoAndVerify(req, userId);

        // save recheck request to mysql in order to send messages and emails in old webmaster about virus recheck
        virusedHostService.recheckHost(briefHostInfo);

        // create virus recheck request in new webmaster and return it to frontend
        RecheckInfo recheckInfo = newWebmasterProxyService.recheckVirus(userId, briefHostInfo);
        if (recheckInfo != null && recheckInfo.getDate() != null) {
            res.addData(new DateWrapper("recheck-date", recheckInfo.getDate()));
        }
    }

    @Required
    public void setNewWebmasterProxyService(NewWebmasterProxyService newWebmasterProxyService) {
        this.newWebmasterProxyService = newWebmasterProxyService;
    }

    @Required
    public void setVirusedHostService(VirusedHostService virusedHostService) {
        this.virusedHostService = virusedHostService;
    }
}
