package ru.yandex.wmconsole.servantlet.xmlsearch;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.service.LinkType;
import ru.yandex.wmconsole.service.UrlTreeService;
import ru.yandex.wmtools.common.data.xmlsearch.UrlsRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

public class IndexUrlsServantlet extends AbstractXmlSearchServantlet {
    protected UrlTreeService urlTreeService;

    @Override
    protected String getXslFileName() {
        return "/xsl/index_urls.xsl";
    }

    @Override
    protected LinkType getLinkType() {
        return LinkType.INDEX_URLS;
    }

    @Override
    protected XmlSearchRequest createRequest(String hostName, String path, TimeFilter timeFilter, Pager pager,
                                             ServRequest req) throws UserException {
        return new UrlsRequest(hostName, path, timeFilter, pager.getPageNum(), pager.getPageSize());
    }

    @Override
    protected boolean isAbsolutePath() {
        return false;
    }

    @Override
    protected boolean needPunycodeHostName() {
        return true;
    }

    @Override
    protected Long getDocsCount(ServRequest req, BriefHostInfo briefHostInfo, TimeFilter timeFilter, String path) throws InternalException {
        if (timeFilter.getFromInMilliseconds() == null &&
                timeFilter.getToInMilliseconds() == null &&
                path.equals("*")) {
            return urlTreeService.getPreciseIndexCount(briefHostInfo);
        } else {
            return null;
        }
    }

    @Required
    public void setUrlTreeService(UrlTreeService urlTreeService) {
        this.urlTreeService = urlTreeService;
    }
}
