package ru.yandex.wmconsole.servantlet.xmlsearch;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.service.LinkType;
import ru.yandex.wmtools.common.data.xmlsearch.IntLinksRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

public class InternalLinksServantlet extends AbstractXmlSearchServantlet {
    @Override
    protected String getXslFileName() {
        return "/xsl/linkint.xsl";
    }

    @Override
    protected LinkType getLinkType() {
        return LinkType.INTERNAL_LINKS;
    }

    @Override
    protected XmlSearchRequest createRequest(String hostName, String path, TimeFilter timeFilter, Pager pager,
                                             ServRequest req) throws UserException {
        return new IntLinksRequest(hostName, path, timeFilter, pager.getPageNum(), pager.getPageSize());
    }

    @Override
    protected boolean isAbsolutePath() {
        return false;
    }
}
