package ru.yandex.wmconsole.servantlet.xmlsearch;

import org.jdom.Document;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.webmaster.common.urltree.YandexSearchShard;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.service.LinkType;
import ru.yandex.wmtools.common.data.xmlsearch.LinksFromHostRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

public class LinksFromHostServantlet extends AbstractXmlSearchServantlet {
    @Override
    protected String getXslFileName() {
        return "/xsl/link.xsl";
    }

    @Override
    protected LinkType getLinkType() {
        return LinkType.LINKS;
    }

    @Override
    protected void cacheToDbDataOfResultDocument(HostDbHostInfo hostDbHostInfo, String path, TimeFilter timeFilter, Document response, YandexSearchShard searchShard) {
        // to override saving to db cache
    }

    @Override
    protected XmlSearchRequest createRequest(String hostName, String path, TimeFilter timeFilter, Pager pager, ServRequest req) throws UserException {
        String fromHost = getRequiredStringParam(req, "fromhost");
        return new LinksFromHostRequest(hostName, path, timeFilter, fromHost, pager.getPageNum(), pager.getPageSize());
    }

    @Override
    protected boolean needPunycodeDomain() {
        return true;
    }

    @Override
    protected boolean isAbsolutePath() {
        return false;
    }
}
