package ru.yandex.wmconsole.servantlet.xmlsearch;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.service.LinkType;
import ru.yandex.wmtools.common.data.wrappers.LongWrapper;
import ru.yandex.wmtools.common.data.xmlsearch.LinksCountRequest;
import ru.yandex.wmtools.common.data.xmlsearch.LinksGroupsRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

public class LinksServantlet extends AbstractXmlSearchServantlet {
    private static final String PARAM_LAST = "last";
    private static final String PARAM_PATH = "path";

    @Override
    protected String getXslFileName() {
        return "/xsl/link.xsl";
    }

    @Override
    protected LinkType getLinkType() {
        return LinkType.LINKS;
    }

    @Override
    protected XmlSearchRequest createRequest(String hostName, String path, TimeFilter timeFilter, Pager pager,
                                             ServRequest req) throws UserException {
        return new LinksGroupsRequest(hostName, path, timeFilter, pager.getPageNum(), pager.getPageSize());
    }

    protected XmlSearchRequest createLinksCountRequest(String hostName, String path, TimeFilter timeFilter, Pager pager,
                                             ServRequest req) throws UserException {
        return new LinksCountRequest(hostName, path, timeFilter, pager.getPageNum(), pager.getPageSize());
    }

    @Override
    public void doProcess(final ServRequest req, final ServResponse res, final long userId) throws UserException, InternalException {

        final BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        final HostDbHostInfo hostDbHostInfo = getHostDbHostInfoService().getHostDbHostInfo(hostInfo.getName());
        // Получение списка внешних ссылок с помощью запроса в режиме deep
        doXmlSearch(req, res, userId, false, hostInfo, hostDbHostInfo);

        // Получение числа внешних ссылок с помощью запроса в режиме flat
        TimeFilter timeFilter = prepareTimeFilter(getIntParam(req, PARAM_LAST));
        String path = req.getParam(PARAM_PATH, true);
        path = preparePath(hostInfo, path);
        Pager pager = createOutputStrategy(req).createDefaultPager();
        // Выполняем запрос без кэширования в tbl_links_cache т.к. отфильтрованные данные по времени
        // не нужно сохранять в кэш
        final Long linksCount =
                getIndexInfoService().extractLinksCount(
                        createLinksCountRequest(hostInfo.getName(), path, timeFilter, pager, req));
        res.addData(new LongWrapper("links-count", linksCount));
    }

    @Override
    protected boolean needPunycodeDomain() {
        return true;
    }

    @Override
    protected boolean isAbsolutePath() {
        return false;
    }
}
