package ru.yandex.wmconsole.viewer.api;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

import java.util.Date;

/**
 * User: azakharov
 * Date: 26.02.14
 * Time: 18:42
 */
public class ApiExtendedSiteInfo extends ApiBaseHostInfo {

    private final Long urlErrors;
    private final Long internalLinksCount;
    private final Long linksCount;

    public ApiExtendedSiteInfo(long id, String name, VerificationStateEnum verificationState, VerificationTypeEnum verificationType, Long urls, boolean isVirused, Integer tcy, Long indexCount, HostInfoStatusEnum hostInfoStatus, Date lastAccess, boolean isMainMirror, Long urlErrors, Long internalLinksCount, Long linksCount) {
        super(id, name, verificationState, verificationType, urls, isVirused, tcy, indexCount, hostInfoStatus, lastAccess, isMainMirror);
        this.urlErrors = urlErrors;
        this.internalLinksCount = internalLinksCount;
        this.linksCount = linksCount;
    }

    public Long getUrlErrors() {
        return urlErrors;
    }

    public Long getInternalLinksCount() {
        return internalLinksCount;
    }

    public Long getLinksCount() {
        return linksCount;
    }
}
