package ru.yandex.wmconsole.viewer.api;

import ru.yandex.webmaster.common.host.HostNodeInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * User: azakharov
 * Date: 26.02.14
 * Time: 16:11
 */
public class ApiHostNodeInfo extends ApiBaseHostInfo {
    private final List<ApiHostNodeInfo> children;

    public ApiHostNodeInfo(HostNodeInfo hostNodeInfo) {
        super(hostNodeInfo.getHostId(), hostNodeInfo.getHostName(), hostNodeInfo.getVerificationState(),
                hostNodeInfo.getVerificationType(), hostNodeInfo.getUrls(), hostNodeInfo.isVirused(),
                hostNodeInfo.getTcy(), hostNodeInfo.getIndexCount(), hostNodeInfo.getHostInfoStatus(),
                hostNodeInfo.getLastAccess(), hostNodeInfo.getMainMirrorHostId() == null);
        children = new ArrayList<>(hostNodeInfo.getChildren().size());
        for (HostNodeInfo child : hostNodeInfo.getChildren()) {
            children.add(new ApiHostNodeInfo(child));
        }
    }

    public List<ApiHostNodeInfo> getChildren() {
        return children;
    }
}
