package ru.yandex.wmconsole.viewer.api;

/**
 * @author aherman
 */
public enum ApiLinkType {
    UNKNOWN(                ""),

    SELF(                   "self"),

    // API v 1.0
    HOST_LIST(              "host-list"),
    HOST_INFORMATION(       "host-information"),
    VERIFY_HOST(            "verify-host"),
    EXCLUDED_URLS(          "excluded-urls"),
    INDEXED_URLS(           "indexed-urls"),
    INCOMING_LINKS(         "incoming-links"),
    TOP_QUERIES(            "top-queries"),


    SITEMAPS(               "sitemaps"),
    SITEMAP(                "sitemap"),
    SITEMAP_INDEX_CHILDREN( "sitemap-index-children"),
    ORIGINAL_TEXTS(         "original-texts"),
    ORIGINAL_TEXT(          "original-text"),
    TIC_HISTORY(            "tic-history"),
    INCOMING_LINKS_HISTORY( "incoming-links-history"),
    CRAWLED_URLS_HISTORY(   "crawled-urls-history"),
    INDEXED_URLS_HISTORY(   "indexed-urls-history"),
    EXCLUDED_URLS_HISTORY(  "excluded-urls-history"),

    // EXTERNAL_RESOURCES
    SITEMAP_CONTENT(        "sitemap-content"),
    ;

    private final String rel;

    private ApiLinkType(String rel) {
        this.rel = rel;
    }

    public String getRel() {
        return rel;
    }
}
