package ru.yandex.wmconsole.viewer.api.servantlet.history;

import java.util.ArrayList;
import java.util.List;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;

import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmconsole.authorization.ApiOAuthPermission;
import ru.yandex.wmconsole.viewer.api.SiteHistoryType;

/**
 * @author aherman
 */
public class ApiGetTicHistoryServantlet extends AbstractApiGetHistoryServantlet {

    @Override
    protected SiteHistoryType getHistoryType() {
        return SiteHistoryType.TIC;
    }

    @Override
    protected List<Pair<DateTime, Long>> filterData(List<Pair<DateTime, Long>> data) {
        List<Pair<DateTime, Long>> filteredData = new ArrayList<Pair<DateTime, Long>>();
        Pair<DateTime, Long> lastData = data.get(0);
        LocalDate lastStartOfMonth = toStartOfMonth(lastData.getFirst());
        filteredData.add(lastData);

        for (Pair<DateTime, Long> pair : data) {
            LocalDate currentStartOfMonth = toStartOfMonth(pair.getFirst());
            if (pair.getSecond().equals(lastData.getSecond()) && lastStartOfMonth.equals(currentStartOfMonth)) {
                continue;
            }

            filteredData.add(pair);
            lastData = pair;
            lastStartOfMonth = currentStartOfMonth;
        }

        return filteredData;
    }

    @Override
    public ApiOAuthPermission getRequiredPermission() {
        return ApiOAuthPermission.COMMON_OPERATIONS;
    }
}
