package ru.yandex.wmconsole.viewer.api.servantlet.originals;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.error.ClientProblem;
import ru.yandex.wmconsole.viewer.api.servantlet.ApiParameterNames;
import ru.yandex.wmconsole.viewer.api.servantlet.OkResponse;

/**
 * @author aherman
 */
public class ApiDeleteOriginalTextServantlet extends ApiBaseOriginalTextsServantlet {
    private static final Logger log = LoggerFactory.getLogger(ApiDeleteOriginalTextServantlet.class);

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId, BriefHostInfo briefHostInfo)
            throws ClientException
    {
        String baseId = getRequiredStringParam(req, ApiParameterNames.ORIGINAL_TEXT_ID);
        try {
            originalTextsService.deleteText(briefHostInfo, baseId);
            res.addData(new OkResponse());
        } catch (IOException e) {
            log.error("Unable to delete original text", e);
            throw new ClientException(ClientProblem.INTERNAL_ERROR, "Unable to delete original text");
        }
    }
}
