package ru.yandex.wmconsole.viewer.api.servantlet.originals;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.util.PageUtils;
import ru.yandex.wmconsole.viewer.api.ApiUrl;
import ru.yandex.wmconsole.viewer.api.servantlet.ApiParameterNames;
import ru.yandex.wmconsole.viewer.originals.OriginalsResponse;

/**
 * @author aherman
 */
public class ApiListOriginalTextsServantlet extends ApiBaseOriginalTextsServantlet {
    private static final int DEFAULT_PAGE_SIZE = 10;

    private ApiUrl apiUrl;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId, BriefHostInfo briefHostInfo)
            throws ClientException
    {
        Integer page = req.getParamAsInteger(ApiParameterNames.PAGE, 0);
        PageUtils.Pager pager = PageUtils.getPage(page, DEFAULT_PAGE_SIZE);

        ApiUrl.V2.Host host = apiUrl.v2().host(briefHostInfo.getId());
        OriginalsResponse originalsResponse = originalTextsService.listTexts(briefHostInfo, pager);
        res.addData(new OriginalTextsReponse(originalsResponse, host, false));
    }

    @Required
    public void setApiUrl(ApiUrl apiUrl) {
        this.apiUrl = apiUrl;
    }
}
