package ru.yandex.wmconsole.viewer.api.servantlet.originals;

import ru.yandex.webmaster.common.util.xml.SimpleXmlBuilder;
import ru.yandex.wmconsole.viewer.api.ApiLink;
import ru.yandex.wmconsole.viewer.api.ApiLinkType;
import ru.yandex.wmconsole.viewer.api.ApiUrl;
import ru.yandex.wmconsole.viewer.api.ApiXmlUtils;
import ru.yandex.wmconsole.viewer.originals.OriginalText;
import ru.yandex.wmconsole.viewer.originals.OriginalsResponse;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author aherman
 */
public class OriginalTextsReponse extends XmlDataWrapper<OriginalsResponse> {
    private final ApiUrl.V2.Host apiHostUrl;
    private boolean singleEntryOnly;

    public OriginalTextsReponse(OriginalsResponse data, ApiUrl.V2.Host apiHostUrl, boolean singleEntryOnly) {
        super(data);
        this.apiHostUrl = apiHostUrl;
        this.singleEntryOnly = singleEntryOnly;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        OriginalsResponse originalsResponse = data;

        SimpleXmlBuilder xml = new SimpleXmlBuilder(result, false);
        if (singleEntryOnly) {
            if (originalsResponse.getTexts().isEmpty()) {
                xml.open("original-text");
                xml.close();
            } else {
                createOriginalTextXml(xml, originalsResponse.getTexts().get(0));
            }
        } else {
            createOriginalTextList(xml, originalsResponse);
        }
    }

    private void createOriginalTextList(SimpleXmlBuilder xml, OriginalsResponse originalsResponse) {
        xml.open("original-texts")
                .attribute("total", originalsResponse.getTotalTexts())
                .attribute("can-add", originalsResponse.isCanAdd());
        for (OriginalText originalText : originalsResponse.getTexts()) {
            createOriginalTextXml(xml, originalText);
        }
        xml.close(); // original-texts
    }

    private void createOriginalTextXml(SimpleXmlBuilder xml, OriginalText originalText) {
        xml.open("original-text");
        xml.element("id", originalText.getId());
        ApiLink originalTextLink = apiHostUrl.originalText(originalText.getId());
        ApiXmlUtils.link(xml, originalTextLink.getUri(), ApiLinkType.SELF);
        xml.open("content").cdataText(originalText.getText()).close();
        xml.close(); // original-text
    }
}
