package ru.yandex.wmconsole.viewer.api.servantlet.sitemap;

import java.net.URL;
import java.util.Collections;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.viewer.service.NewWebmasterProxyService;
import ru.yandex.wmconsole.authorization.ApiOAuthPermission;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.SitemapInfo;
import ru.yandex.wmconsole.data.sitemaps.SitemapSourceEnum;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.error.ClientProblem;
import ru.yandex.wmconsole.servantlet.api.AbstractApiServantlet;
import ru.yandex.webmaster.common.sitemap.SitemapService;
import ru.yandex.wmconsole.viewer.api.ApiUrl;
import ru.yandex.wmconsole.viewer.sitemap.SitemapId;
import ru.yandex.wmconsole.viewer.sitemap.SitemapLink;
import ru.yandex.wmconsole.viewer.sitemap.SitemapService2;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author aherman
 */
public class ApiAddSitemapServantlet extends AbstractApiServantlet {
    private static final Logger log = LoggerFactory.getLogger(ApiAddSitemapServantlet.class);

    private SitemapService2 sitemapService2;
    private SitemapService sitemapService;
    private NewWebmasterProxyService newWebmasterProxyService;

    private ApiUrl apiUrl;

    @Override
    protected void apiDoProcess(ServRequest req, ServResponse res, long userId) throws ClientException, InternalException {
        String sitemapUrlString = getRequiredXmlParam(req, "/sitemap/link/@href");

        URL sitemapUrl;
        try {
            sitemapUrl = prepareHostname(sitemapUrlString, true);
        } catch (UserException e) {
            throw new ClientException(ClientProblem.INVALID_URL, "Invalid sitemap url: " + sitemapUrlString, e);
        }

        try {
            BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, false, false);
            sitemapService2.getAndValidateSitemap(sitemapUrl);

            SitemapInfo sitemapInfo = sitemapService.addSitemap(userId, req.getUserId(), briefHostInfo, sitemapUrl);
            try {
                newWebmasterProxyService.addSitemap(briefHostInfo, userId, sitemapUrl.toExternalForm());
            } catch (InternalException e) {
                log.error("Failed to add sitemap " + sitemapUrl + " for host " + briefHostInfo.getName() + " to new WM", e);
            }
            SitemapLink sitemapLink = new SitemapLink(new SitemapId(sitemapInfo.getId(), SitemapSourceEnum.IN_SEARCH), sitemapInfo.getUrl());
            ApiUrl.V2.Host host = apiUrl.v2().host(briefHostInfo.getId());
            res.addData(new SitemapListWrapper(Collections.singletonList(sitemapLink), 1, true, host));
        } catch (UserException e) {
            log.error("Unable to add sitemap", e);
            throw new ClientException(ClientProblem.INVALID_URL, e.getMessage(), e);
        }
    }

    @Override
    public ApiOAuthPermission getRequiredPermission() {
        return ApiOAuthPermission.COMMON_OPERATIONS;
    }

    @Required
    public void setSitemapService2(SitemapService2 sitemapService2) {
        this.sitemapService2 = sitemapService2;
    }

    @Required
    public void setSitemapService(SitemapService sitemapService) {
        this.sitemapService = sitemapService;
    }

    @Required
    public void setApiUrl(ApiUrl apiUrl) {
        this.apiUrl = apiUrl;
    }

    @Required
    public void setNewWebmasterProxyService(NewWebmasterProxyService newWebmasterProxyService) {
        this.newWebmasterProxyService = newWebmasterProxyService;
    }
}
