package ru.yandex.wmconsole.viewer.api.servantlet.sitemap;

import java.util.Collections;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.authorization.ApiOAuthPermission;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.MergedSitemapInfo;
import ru.yandex.wmconsole.data.sitemaps.SitemapSourceEnum;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.error.ClientProblem;
import ru.yandex.wmconsole.servantlet.api.AbstractApiServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.webmaster.common.sitemap.SitemapService;
import ru.yandex.wmconsole.viewer.api.SitemapIdApiFormatter;
import ru.yandex.wmconsole.viewer.api.servantlet.ApiParameterNames;
import ru.yandex.wmconsole.viewer.api.servantlet.OkResponse;
import ru.yandex.wmconsole.viewer.sitemap.SitemapId;
import ru.yandex.wmconsole.viewer.sitemap.SitemapService2;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author aherman
 */
public class ApiDeleteSitemapServantlet extends AbstractApiServantlet {
    private SitemapService2 sitemapService2;
    private SitemapService sitemapService;
    private HostDbHostInfoService hostDbHostInfoService;

    @Override
    protected void apiDoProcess(ServRequest req, ServResponse res, long userId) throws ClientException, InternalException {
        String externalId = getRequiredStringParam(req, ApiParameterNames.SITEMAP_ID);
        SitemapId sitemapId = SitemapIdApiFormatter.parseFromExternalId(externalId);

        try {
            BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, false, false);
            HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(briefHostInfo.getName());

            MergedSitemapInfo latestSitemap = null;
            MergedSitemapInfo inSearchSitemap;

            if (sitemapId.getSitemapSource() == SitemapSourceEnum.LATEST) {
                latestSitemap = sitemapService2.getCurrentSitemap(hostDbHostInfo, sitemapId, null);
                inSearchSitemap = sitemapService2.getOldSitemap(hostDbHostInfo, latestSitemap);
            } else {
                inSearchSitemap = sitemapService2.getOldSitemap(hostDbHostInfo, sitemapId);
            }

            if (inSearchSitemap != null) {
                sitemapService.removeSitemaps(hostDbHostInfo, userId, userId, Collections.singletonList(
                        inSearchSitemap.getId()));
            }
            res.addData(new OkResponse());
        } catch (UserException e) {
            throw new ClientException(ClientProblem.INTERNAL_ERROR, e.getMessage(), e);
        }
    }

    @Override
    public ApiOAuthPermission getRequiredPermission() {
        return ApiOAuthPermission.COMMON_OPERATIONS;
    }

    @Required
    public void setSitemapService2(SitemapService2 sitemapService2) {
        this.sitemapService2 = sitemapService2;
    }

    @Required
    public void setSitemapService(SitemapService sitemapService) {
        this.sitemapService = sitemapService;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }
}
