package ru.yandex.wmconsole.viewer.api.servantlet.sitemap;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.wmconsole.authorization.ApiOAuthPermission;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.servantlet.api.AbstractApiServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.util.PageUtils;
import ru.yandex.wmconsole.viewer.api.ApiUrl;
import ru.yandex.wmconsole.viewer.api.servantlet.ApiParameterNames;
import ru.yandex.wmconsole.viewer.sitemap.SitemapLink;
import ru.yandex.wmconsole.viewer.sitemap.dao.TblSitemapMetaDao;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author aherman
 */
public class ApiListSitemapsServantlet extends AbstractApiServantlet {
    private static final int DEFAULT_PAGE_SIZE = 50;

    private TblSitemapMetaDao tblSitemapMetaDao;
    private HostDbHostInfoService hostDbHostInfoService;
    private ApiUrl apiUrl;

    @Override
    protected void apiDoProcess(ServRequest req, ServResponse res, long userId) throws ClientException, InternalException {
        int pageNumber = req.getParamAsInt(ApiParameterNames.PAGE, 0);

        BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, false, false);
        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(briefHostInfo.getName());
        int sitemapCount = tblSitemapMetaDao.countSitemaps(hostDbHostInfo);

        PageUtils.Pager page = PageUtils.getPage(pageNumber, DEFAULT_PAGE_SIZE, sitemapCount);
        List<SitemapLink> sitemapLinks = Collections.emptyList();

        if (!page.isEmpty()) {
            sitemapLinks = tblSitemapMetaDao.listSitemaps(hostDbHostInfo,
                    SqlLimits.range(page.toRangeStart(), page.getPageSize()));
        }

        ApiUrl.V2.Host host = apiUrl.v2().host(briefHostInfo.getId());
        res.addData(new SitemapListWrapper(sitemapLinks, sitemapCount, false, host));
    }

    @Override
    public ApiOAuthPermission getRequiredPermission() {
        return ApiOAuthPermission.COMMON_OPERATIONS;
    }

    @Required
    public void setTblSitemapMetaDao(TblSitemapMetaDao tblSitemapMetaDao) {
        this.tblSitemapMetaDao = tblSitemapMetaDao;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }

    @Required
    public void setApiUrl(ApiUrl apiUrl) {
        this.apiUrl = apiUrl;
    }
}
