package ru.yandex.wmconsole.viewer.api.servantlet.sitemap;

import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.webmaster.common.util.xml.SimpleXmlBuilder;
import ru.yandex.wmconsole.viewer.api.ApiLink;
import ru.yandex.wmconsole.viewer.api.ApiLinkType;
import ru.yandex.wmconsole.viewer.api.ApiUrl;
import ru.yandex.wmconsole.viewer.api.ApiXmlUtils;
import ru.yandex.wmconsole.viewer.sitemap.SitemapLink;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
* @author aherman
*/
public class SitemapListWrapper extends XmlDataWrapper<List<SitemapLink>> {
    @Nullable
    private ApiUrl.V2.Host apiHostUrl;

    private final int totalSitemaps;
    private final boolean singleItem;

    public SitemapListWrapper(List<SitemapLink> data, int totalSitemaps, boolean singleItem, @NotNull ApiUrl.V2.Host apiHostUrl) {
        super(data);
        this.totalSitemaps = totalSitemaps;
        this.singleItem = singleItem;
        this.apiHostUrl = apiHostUrl;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        SimpleXmlBuilder xml = new SimpleXmlBuilder(result);
        if (singleItem) {
            createSitemap(xml, data.get(0));
        } else {
            createSitemaps(xml);
        }
    }

    private void createSitemaps(SimpleXmlBuilder xml) {
        xml.open("sitemaps");
        xml.attribute("total", totalSitemaps);

        for (SitemapLink sitemapLink : data) {
            createSitemap(xml, sitemapLink);
        }
        xml.close(); // sitemaps
    }

    private void createSitemap(SimpleXmlBuilder xml, SitemapLink sitemapLink) {
        xml.open("sitemap");

        ApiXmlUtils.link(xml, sitemapLink.getSitemapUrl(), ApiLinkType.SITEMAP_CONTENT);

        if (apiHostUrl != null) {
            ApiLink sitemapApiLink = apiHostUrl.sitemap(sitemapLink.getSitemapId());
            ApiXmlUtils.link(xml, sitemapApiLink.getUri(), ApiLinkType.SELF);
        }

        xml.close(); // sitemap
    }
}
