package ru.yandex.wmconsole.viewer.api.wrappers;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 26.02.14
 * Time: 11:52
 */
public class ApiAddHostWrapper extends XmlDataWrapper<XmlConvertable> {
    private final String hostName;

    public ApiAddHostWrapper(XmlConvertable element, BriefHostInfo briefHostInfo, long userId) {
        super(element, "host", "id", Long.toString((briefHostInfo == null) ? -1 : briefHostInfo.getId()),
                "user", Long.toString(userId));
        this.hostName = (briefHostInfo == null) ? "" : briefHostInfo.getName();
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, "name", hostName);
        if (data != null) {
            data.toXml(result);
        }
    }
}
