package ru.yandex.wmconsole.viewer.api.wrappers;

import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.api.ApiVerificationState;
import ru.yandex.wmconsole.data.wrappers.api.ApiHostInfoWrapper;
import ru.yandex.wmconsole.viewer.api.ApiBaseHostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 26.02.14
 * Time: 18:44
 */
public class ApiBaseHostInfoWrapper<T extends ApiBaseHostInfo> extends ApiHostInfoWrapper<T> {

    public ApiBaseHostInfoWrapper(T info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.isMainMirror()) {
            super.doToXml(result);
        } else {
            putHostnameTag(result, TAG_NAME, data.getName());

            ApiVerificationState verState = ApiVerificationState.getByVerifcationStateAndType(
                    data.getVerificationState(), data.getVerificationType());
            VerificationStateEnum verDetails = (ApiVerificationState.VERIFICATION_FAILED.equals(verState) &&
                    !data.getVerificationState().isInternal()) ? data.getVerificationState() : null;
            XmlDataWrapper<VerificationStateEnum> verificationDetailsWrapper =
                    verDetails != null ? new InnerElementWrapper(verDetails, TAG_VERIFICATION_DETAILS) : null;
            putComplexTag(result, TAG_VERIFICATION, verificationDetailsWrapper,
                    ATTRIBUTE_VERIFICATION_STATE, verState.toString());
            if (!ApiVerificationState.VERIFIED.equals(verState)) {
                return;
            }
            putBooleanTag(result, TAG_VIRUSED, data.isVirused());
        }
    }
}
