package ru.yandex.wmconsole.viewer.api.wrappers;

import ru.yandex.wmconsole.data.api.ApiVerificationState;
import ru.yandex.wmconsole.viewer.api.ApiExtendedSiteInfo;

/**
 * User: azakharov
 * Date: 26.02.14
 * Time: 18:24
 */
public class ApiExtendedSiteInfoWrapper extends ApiBaseHostInfoWrapper<ApiExtendedSiteInfo> {

    private static final String TAG_URL_ERRORS = "url-errors";
    private static final String TAG_INTERNAL_LINKS_COUNT = "internal-links-count";
    private static final String TAG_LINKS_COUNT = "links-count";

    public ApiExtendedSiteInfoWrapper(ApiExtendedSiteInfo info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);
        if (data.isMainMirror()) {
            ApiVerificationState verState = ApiVerificationState.getByVerifcationStateAndType(
                    data.getVerificationState(), data.getVerificationType());
            if (!ApiVerificationState.VERIFIED.equals(verState)) {
                return;
            }

            long urlCount = data.getUrls() == null ? 0 : data.getUrls();
            long indexCount = data.getIndexCount() == null ? 0 : data.getIndexCount();

            if (urlCount < indexCount) {
                urlCount = indexCount;
            }

            boolean indexed = urlCount > 0;
            if (!indexed) {
                return;
            }

            putLongTag(result, TAG_URL_ERRORS, data.getUrlErrors());
            putLongTag(result, TAG_INTERNAL_LINKS_COUNT, data.getInternalLinksCount());
            putLongTag(result, TAG_LINKS_COUNT, data.getLinksCount());
        }
    }
}
