package ru.yandex.wmconsole.viewer.api.wrappers;

import ru.yandex.wmconsole.viewer.api.ApiHostNodeInfo;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * User: azakharov
 * Date: 26.02.14
 * Time: 16:09
 */
public class ApiHostNodeInfoWrapper extends ApiBaseHostInfoWrapper<ApiHostNodeInfo> {

    private static final String TAG_MIRRORS = "mirrors";

    public ApiHostNodeInfoWrapper(ApiHostNodeInfo info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);
        if (data.isMainMirror() && !data.getChildren().isEmpty()) {
            XmlConvertableCollectionWrapper wrapper =
                    XmlConvertableCollectionWrapper.wrap(data.getChildren(), ApiHostNodeInfoWrapper.class, TAG_MIRRORS);
            wrapper.toXml(result);
        }
    }
}
