package ru.yandex.wmconsole.viewer.originals;

import java.util.List;

/**
 * @author aherman
 */
public class OriginalsResponse {
    private final int totalTexts;
    private final boolean canAdd;
    private final OriginalsError error;

    private final List<OriginalText> texts;

    public OriginalsResponse(int totalTexts, boolean canAdd, List<OriginalText> texts, OriginalsError errorState) {
        this.totalTexts = totalTexts;
        this.canAdd = canAdd;
        this.texts = texts;
        this.error = errorState;
    }

    public int getTotalTexts() {
        return totalTexts;
    }

    public boolean isCanAdd() {
        return canAdd;
    }

    public List<OriginalText> getTexts() {
        return texts;
    }

    public OriginalsError getError() {
        return error;
    }

    public boolean isErrorState() {
        return error != OriginalsError.NO_ERROR;
    }


    public static enum OriginalsError {
        NO_ERROR,

        TEXT_ALREADY_ADDED,
        UNKNOWN_ERROR
    }
}
