package ru.yandex.wmconsole.viewer.sitemap.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.sitemap.SitemapIndexInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.data.sitemaps.SitemapSourceEnum;
import ru.yandex.wmconsole.viewer.sitemap.SitemapId;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author aherman
 */
public class TblSitemapIndexMetaDao extends AbstractDbService {

    public List<SitemapIndexInfo> getSitemapIndexInfo(HostDbHostInfo hostDbHostInfo, SitemapId sitemapId)
            throws InternalException
    {
        String q =
                "SELECT " +
                "    csi.index_id AS index_id, " +
                "    cs.url_name AS url_name, " +
                "    cs.host_name AS host_name " +
                "  FROM " +
                "    tbl_sitemaps_indexes_cur csi " +
                "  JOIN " +
                "    tbl_sitemaps_cur cs " +
                "  ON " +
                "    csi.index_id = cs.sitemap_id " +
                "  WHERE " +
                "    csi.sitemap_id = ? " +
                "  ORDER BY cs.host_name ASC, cs.url_name ASC";

        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(q, getSitemapIndexInfoMapper(), sitemapId.getSitemapId());
    }

    public int countSitemapIndexChildren(HostDbHostInfo hostDbHostInfo, SitemapId sitemapId) throws InternalException {
        String q = "SELECT count(*) FROM tbl_sitemaps_indexes_cur WHERE index_id = ? AND host_id = ?";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).queryForInt(q, sitemapId.getSitemapId(),
                hostDbHostInfo.getHostDbHostId());
    }

    public List<SitemapId> getSitemapIndexChildren(HostDbHostInfo hostDbHostInfo, SitemapId sitemapId,
            SqlLimits sqlLimits)
            throws InternalException
    {
        String q = "SELECT sitemap_id FROM tbl_sitemaps_indexes_cur WHERE index_id = ? AND host_id = ? " + sqlLimits.toMysqlLimits();
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(q, getIndexChildIdMapper(),
                sitemapId.getSitemapId(), hostDbHostInfo.getHostDbHostId());
    }

    private ParameterizedRowMapper<SitemapIndexInfo> getSitemapIndexInfoMapper() {
        return new ParameterizedRowMapper<SitemapIndexInfo>() {
            @Override
            public SitemapIndexInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new SitemapIndexInfo(
                        rs.getLong("index_id"),
                        rs.getString("url_name"),
                        rs.getString("host_name"));
            }
        };
    }

    private ParameterizedRowMapper<SitemapId> getIndexChildIdMapper() {
        return new ParameterizedRowMapper<SitemapId>() {
            @Override
            public SitemapId mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new SitemapId(rs.getLong("sitemap_id"), SitemapSourceEnum.LATEST);
            }
        };
    }
}
