<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>
    <xsl:template match="/">
	<wrapper>
        <docs count="{/yandexsearch/response/results/grouping/found-docs[@priority='strict']}">
            <xsl:apply-templates select="/yandexsearch/response/results/grouping/group"/>
        </docs>
        <xsl:variable name="docscount">
            <xsl:value-of select="count(/yandexsearch/response/results/grouping/group/doc)"/>
        </xsl:variable>
        <xsl:if test="$docscount > 0">
            <xsl:call-template name="create-pager"/>
        </xsl:if>
        </wrapper>
    </xsl:template>

    <xsl:template match="group">
        <xsl:element name="doc">
            <xsl:copy-of select="doc/url"/>
            <xsl:copy-of select="doc/title"/>
        </xsl:element>
    </xsl:template>

    <xsl:template name="create-pager">
        <xsl:variable name="count">
            <xsl:choose>
                <xsl:when test="/yandexsearch/response/results/grouping/found[@priority='strict']">
                    <xsl:value-of select="/yandexsearch/response/results/grouping/found[@priority='strict']"/>
                </xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="page-num" select="/yandexsearch/request/page"/>
        <xsl:variable name="page-size" select="/yandexsearch/request/groupings/groupby/@groups-on-page"/>
        <xsl:variable name="total-page-count" select="floor($count div $page-size) + 1"/>
        <pager count="{$count}" page-size="{$page-size}" total-page-count="{$total-page-count}">
            <xsl:call-template name="create-page">
                <xsl:with-param name="num">
                    <xsl:choose>
                        <xsl:when test="$page-num &gt; 8">
                            <xsl:value-of select="$page-num - 8"/>
                        </xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>
                    </xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="numMax">
                    <xsl:choose>
                        <xsl:when test="$page-num + 8 &lt; $total-page-count - 1">
                            <xsl:value-of select="$page-num + 8"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$total-page-count - 1"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="current-num" select="$page-num"/>
            </xsl:call-template>
        </pager>
    </xsl:template>
    
    <xsl:template name="create-page">
        <xsl:param name="num"/>
        <xsl:param name="numMax"/>
        <xsl:param name="current-num"/>
        <page num="{$num}">
            <xsl:if test="$num = $current-num">
                <xsl:attribute name="current">true</xsl:attribute>
            </xsl:if>
        </page>
        <xsl:if test="$num &lt; $numMax">
            <xsl:call-template name="create-page">
                <xsl:with-param name="num" select="$num + 1"/>
                <xsl:with-param name="numMax" select="$numMax"/>
                <xsl:with-param  name="current-num" select="$current-num"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
