#!/bin/bash

OS_VERSION=$1
ARCH=$2

[ -n "${OS_VERSION}" ] || { echo "ERROR: Os version is not set, use ./debuild-*.sh"; exit 1; }
echo "OS_VERSION=${OS_VERSION}"

[ -n "${ARCH}" ] || { echo "ERROR: Architecture is not set, use ./debuild-*.sh"; exit 1; }
echo "ARCH=${ARCH}"

[ -d "lib/${OS_VERSION}/${ARCH}" ] || { echo "There are no lib for ${OS_VERSION}/${ARCH}"; echo 1; }

sed \
 -e "s/%OS_VERSION%/${OS_VERSION}/g" \
 -e "s/%ARCH%/${ARCH}/g" \
 debian/yandex-webmaster-libhtnorm.install.template > debian/yandex-webmaster-libhtnorm.install
