#!/bin/sh

if [ x$WMC_CONFIG = "x" ]; then
    WMC_CONFIG=/place/wmconsole/wmconsole.cfg
fi
    
if [ -r $WMC_CONFIG ]; then
    . $WMC_CONFIG
else
    echo "Cannot load config $WMC_CONFIG!" 1>&2
    exit
fi	

LOGS_FILE="$WMCXMLLIMITS_HOME/WMCXmlLimits.log"
prev_date=`date +'%Y-%m-%d'`
errors_cnt=`cat $LOGS_FILE | grep $prev_date | grep -c ERROR`

if [ ! $errors_cnt = 0 ]; then
    errors_sample=`cat $LOGS_FILE | grep $prev_date | grep ERROR  | tail -n 5 | cut -c1-150`
fi

if [ $errors_cnt -lt 10 ]; then
   status="OK"
else
   status="FAIL"
fi

echo "Yesterday's state: $status"
if [ ! $errors_cnt = 0 ]; then
    echo "Errors count: $errors_cnt"
    echo "Error's samples:"
    echo "$errors_sample"
fi
