#include "user_info_map.h"

namespace NWebmaster {

void TUserInfoMap::add_user(size_t db_num, const TUserInfoDB &info) {
    TUserIdMap &array = operator[](db_num);
    TUserInfo &user_info = array[info.get<0>()];
    user_info.db_limit = info.get<1>();
    user_info.set<0>(info.get<0>());
}

const TUserInfo *TUserInfoMap::find_user_id(TUserId id) const {
    for (std::map<size_t, TUserIdMap>::const_iterator p = begin(); p != end(); p++) {
        TUserIdMap::const_iterator iter = p->second.find(id);

        if (iter != p->second.end()) {
            return &(iter->second);
        }
    }
    return nullptr;
}

TUserInfo *TUserInfoMap::find_user_id(TUserId id) {
    for (std::map<size_t, TUserIdMap>::iterator p = begin(); p != end(); p++) {
        TUserIdMap::iterator iter = p->second.find(id);

        if (iter != p->second.end()) {
            return &(iter->second);
        }
    }

    return nullptr;
}

size_t TUserInfoMap::users_count() const {
    size_t result = 0;
    for (const auto &entry: *this) {
        result += entry.second.size();
    }
    return result;
}

} //namespace NWebmaster
