#pragma once

#ifndef USER_INFO_MAP_E0E487491BA44cab9985B513B49512F5
#define USER_INFO_MAP_E0E487491BA44cab9985B513B49512F5

#include <map>

#include <Poco/Tuple.h>

namespace NWebmaster {

typedef Poco::Int64 TUserId;
typedef Poco::Tuple<TUserId, Poco::Int64> TUserInfoDB;

struct TUserInfo : TUserInfoDB {
    TUserInfo() : limit(0), db_limit(0) {}
    Poco::Int64 limit;
    Poco::Int64 db_limit;
};

typedef std::map<TUserId, TUserInfo> TUserIdMap;

struct TUserInfoMap : public std::map<size_t, TUserIdMap> {
    void add_user(size_t db_num, const TUserInfoDB &info);
    const TUserInfo *find_user_id(TUserId id) const;
    TUserInfo *find_user_id(TUserId id);
    size_t users_count() const;
};

} //namespace NWebmaster

#endif
