#include <util/datetime/base.h>

#include "config.h"

namespace NWebmaster {

const TString TConfig::MSG_APPLICATION_NAME = "webmaster-canonizer-daemon";
const TString TConfig::MSG_APPLICATION_VERSION = TConfig::GetProgramRevision();

TConfig::TConfig(NLastGetopt::TOpts &opts)
    : Opts(opts)
{
    opts.AddLongOption("canonizer.daemon.http.server.port", "bind port")
        .StoreResult(&HTTP_SERVER_PORT)
        .OptionalArgument("<int>")
        .DefaultValue(nullptr);
}

void TConfig::Load() {
    TConfigBase::Load();

    //Assign(HTTP_SERVER_PORT, "canonizer.daemon.http.server.port");
    Assign(HTTP_SERVER_THREADS, "canonizer.daemon.http.server.threads");
    Assign(GEMINI_USER, "canonizer.daemon.gemini.client.user");
    Assign(GEMINI_QUOTA, "canonizer.daemon.gemini.client.quota");
    Assign(GEMINI_TIMEOUT, "canonizer.daemon.gemini.client.timeout");
    Assign(BACKENDS, "backends");
}

} //namespace NWebmaster
