#!/bin/dash

PROGRAM=canonizer-daemon

ENV_TYPE=`cat /etc/yandex/environment.type`
BIN_DIR=$(dirname $0)
LOCAL_CONFIG=$BIN_DIR/$PROGRAM.$ENV_TYPE.properties
GLOBAL_CONFIG=$BIN_DIR/$PROGRAM.$ENV_TYPE.properties
RUN_DIR=$BIN_DIR
LOG_DIR=.

LoadConfig() {
    for line in `cat $1 | awk -F'=' -v OFS='=' '{ gsub(/\./, "_", $1); print}'`; do
        eval "$line"
    done;
}

LoadConfig $GLOBAL_CONFIG

exec $BIN_DIR/$PROGRAM -G $GLOBAL_CONFIG -C $LOCAL_CONFIG -L $LOG_DIR/current-webmaster-$PROGRAM.log --canonizer.daemon.http.server.port $canonizer_daemon_http_server_port $*
