#pragma once

#include <robot/gemini/libclient2/client.h>

#include <util/generic/singleton.h>
#include <util/generic/deque.h>
#include <util/system/mutex.h>

namespace NWebmaster {

struct TResolvedUrl {
    TResolvedUrl()
        : ErrorCode(0)
        , HasError(false)
    {
    }

    void SetErrorCode(int errorCode);
    void SetCanonizedUrl(const TString &url, bool keepPath = true);

public:
    int ErrorCode;
    bool HasError;
    TString ErrorName;
    TString Original;
    TString Canonized;
};

struct TReceiver : public NGeminiClient::IResultReceiver {
    void Push(const NGeminiProtos::TCastorResponse& response) override;

public:
    TDeque<TResolvedUrl> Records;
};

class TGeminiCanonizer {
    enum ERequest {
        MIRROR,
        WEAK,
        CASE,
    };

public:
    using Ptr = TAtomicSharedPtr<TGeminiCanonizer>;

    TGeminiCanonizer(const TString &user, size_t rps, size_t timeout, NGeminiProtos::ECanonizationType type = NGeminiProtos::CASE_HOST);
    bool GetCanonical(const TDeque<TString> &urls, TDeque<TResolvedUrl> &resolved);

private:
    TReceiver Receiver;
    NGeminiClient::TConfigPtr Config;
    THolder<NGeminiClient::TClient> Client;

public:
    NGeminiProtos::ECanonizationType Type;
};

} //namespace NWebmaster
