#include "monitor.h"

namespace NWebmaster {

TMonitor::TMonitor()
    : SuccessRequests("CanonizerDaemon_RequestSuccess")
    , FailedRequests("CanonizerDaemon_RequestFailed")
    , RejectedRequests("CanonizerDaemon_RequestRejected")
{
}

void TMonitor::Upload() {
    TMonitoringAgent<> agent;

    agent
        .Next(SuccessRequests)
        .Next(FailedRequests)
        .Next(RejectedRequests)
        .GlobalDerived()
        .Commit();
}

} //namespace NWebmaster
