#pragma once

#include <util/generic/set.h>
#include <util/system/fstat.h>

#include <kernel/hosts/owner/owner.h>
#include <yweb/antispam/common/owner/owner.h>

#include <wmconsole/version3/wmcutil/http_server.h>

#include "config.h"
#include "gem_canon.h"

namespace NWebmaster {

struct TCanonizerContext {
    TCanonizerContext(TGeminiCanonizer::Ptr geminiCaseHostCanonizer)
        : GeminiCaseHostCanonizer(geminiCaseHostCanonizer)
    {
    }

public:
    TGeminiCanonizer::Ptr GeminiCaseHostCanonizer;
};

struct TCanonizerService : THttpServer::TUserService {
    TCanonizerService(const TConfig &config);

    void PrepareGeminiJsonAnswer(TGeminiCanonizer *canonizer, const TDeque<TString> &hosts, TString &output);
    void PrepareGeminiPlainAnswer(TGeminiCanonizer *canonizer, const TDeque<TString> &hosts, TString &output);
    bool MethodGeminiRequest(TGeminiCanonizer *canonizer, THttpServer::TRequest &request);
    bool MethodGeminiCaseHostRequest(THttpServer::TRequest &request);

    bool MethodUrlOwnerRequest(THttpServer::TRequest &request);
    bool MethodHostOwnerRequest(THttpServer::TRequest &request);
    bool MethodMascotUrlOwnerRequest(THttpServer::TRequest &request);
    bool MethodMascotHostOwnerRequest(THttpServer::TRequest &request);

    bool MethodPing(THttpServer::TRequest &request);

    void *CreateThreadSpecificResource() override;
    void DestroyThreadSpecificResource(void *tsr) override;

public:
    const TConfig &Config;

private:
    TOwnerCanonizer KernelOwnerCanonizer;
    TMascotOwnerCanonizer MascotOwnerCanonizer;
};

} //namespace NWebmaster
