#include <util/datetime/base.h>

#include "config.h"

namespace NWebmaster {

const TString TConfig::MSG_APPLICATION_NAME = "webmaster-geo-daemon";
const TString TConfig::MSG_APPLICATION_VERSION = TConfig::GetProgramRevision();

TConfig::TConfig(NLastGetopt::TOpts &opts)
    : Opts(opts)
{
    opts.AddLongOption("geo.daemon.http.server.port", "bind port")
        .StoreResult(&HTTP_SERVER_PORT)
        .OptionalArgument("<int>")
        .DefaultValue(nullptr);
}

void TConfig::Load() {
    TConfigBase::Load();

    //Assign(HTTP_SERVER_PORT, "geo.daemon.http.server.port", 25020);
    Assign(HTTP_SERVER_THREADS, "geo.daemon.http.server.threads", 4);

    Assign(DATA_FILTER_TRIE, "geo.daemon.rsync.filter.file");
    Assign(DATA_MIRRORS_TRIE, "geo.daemon.rsync.mirrors.file");
    Assign(DATA_CATALOG_VISIBLE, "geo.daemon.rsync.catalog_visible.file");

    DATA_FILTER_TRIE = "data" + DATA_FILTER_TRIE.substr(DATA_FILTER_TRIE.rfind('/'));
    DATA_MIRRORS_TRIE = "data" + DATA_MIRRORS_TRIE.substr(DATA_MIRRORS_TRIE.rfind('/'));
    DATA_CATALOG_VISIBLE = "data" + DATA_CATALOG_VISIBLE.substr(DATA_CATALOG_VISIBLE.rfind('/'));
}

} //namespace NWebmaster
