#!/usr/bin/env python

import urllib
import urllib2
import json
import sys

def get_url_content(url):
    headers = { }
    request = urllib2.Request(url, headers=headers)
    response = urllib2.urlopen(request)
    data = response.read()

    return data

def api_request(handler):
    API = "https://sandbox.yandex-team.ru:443/api/v1.0"
    return json.loads(get_url_content(API + handler))

def get_released_tasks(task_type, limit = 1):
    return api_request("/task?type=%s&status=RELEASED&limit=%d" % (task_type, limit))

def get_task_resources(task_id, limit = 100):
    return api_request("/resource?task_id=%d&limit=%d" % (task_id, limit))

def get_resource_info(resource_id):
    return api_request("/resource/%d" % resource_id)

if __name__ == "__main__":
    task_id = int(get_released_tasks(sys.argv[1])["items"][0]["id"])

    for resource in get_task_resources(task_id)["items"]:
        if resource["type"] in sys.argv[2:]:
            resource_id = int(resource["id"])
            print get_resource_info(resource_id)["http"]["proxy"]

#curl 'https://sandbox.yandex-team.ru:443/api/v1.0/task?type=BUILD_FILTER_TRIE&status=RELEASED&limit=1' | jq .
#curl 'https://sandbox.yandex-team.ru/api/v1.0/resource?task_id=85237187&limit=100'
