#include "monitor.h"

namespace NWebmaster {

TMonitor::TMonitor()
    : ProcessedHosts("GeoDaemon_ProcessedHosts")
    , SuccessRequests("GeoDaemon_RequestSuccess")
    , FailedRequests("GeoDaemon_RequestFailed")
{
}

void TMonitor::Upload() {
    TMonitoringAgent<> agent;

    agent
        .Next(ProcessedHosts)
        .Next(SuccessRequests)
        .Next(FailedRequests)
        .GlobalDerived()
        .Commit();
}

} //namespace NWebmaster
