#pragma once

#include <kernel/catfilter/catfilter_wrapper.h>
#include <kernel/mirrors/mirrors_trie.h>
#include <util/generic/set.h>
#include <util/system/fstat.h>
#include <util/system/mutex.h>

#include <wmconsole/version3/protos/geodata.pb.h>
#include <wmconsole/version3/wmcutil/http_server.h>

#include "config.h"
#include "monitor.h"

namespace NWebmaster {

struct TRegion {
    TRegion(i32 regionCode);

public:
    i32 Category;
    i32 Id;
    proto::geodata::AttributeSourceType SourceId;
};

struct TGeoService : THttpServer::TUserService {
    TGeoService(const TConfig &config);
    bool Reply(THttpServer::TRequest &request) override;

    bool MethodGetGeoData(THttpServer::TRequest &request);
    void TryUpdateDataFiles();
    void LoadGeoDataForHost(const TString &host, proto::geodata::HostInfo *hostInfo);

    bool IsVisibleHost(const TString &host);

public:
    const TConfig &Config;

private:
    TFileStat StatFilterTrie;
    TFileStat StatMirrorsTrie;
    TFileStat StatResourceTxt;

    TAtomicSharedPtr<ICatFilter> CatFilter;
    TAtomicSharedPtr<TMirrorsMappedTrie> MirrorsTrie;
    TSet<TString> VisibleHosts;
    TMutex UpdateDataMutex;
    TMonitor &Monitor;
};

} //namespace NWebmaster
