#!/bin/bash

. /usr/lib/yandex/webmaster/geo/daemon/common.sh

function download_resource {
    file_name="$2"
    for resource in $1; do
        wget "$resource" -O "$DATA_DIR/$file_name" >> $LOG_DIR/webmaster-geo-daemon.rsync.log 2>&1
        if [[ $? == 0 ]]; then
            break
        fi
    done
}

#rsync --contimeout=30 --timeout=300 -Wtqr $geo_daemon_rsync_filter_file $DATA_DIR/ >> $LOG_DIR/webmaster-geo-daemon.rsync.log 2>&1
#rsync --contimeout=30 --timeout=300 -Wtqr $geo_daemon_rsync_mirrors_file $DATA_DIR/ >> $LOG_DIR/webmaster-geo-daemon.rsync.log 2>&1
rsync -tq $geo_daemon_rsync_catalog_visible_file $DATA_DIR/ >> $LOG_DIR/webmaster-geo-daemon.rsync.log 2>&1

mirrors_trie_links=`$BIN_DIR/get_sandbox_resource_links.py BUILD_FILTER_TRIE MIRRORS_TRIE`
download_resource "$mirrors_trie_links" "mirrors.trie" >> $LOG_DIR/webmaster-geo-daemon.rsync.log 2>&1

filter_trie_links=`$BIN_DIR/get_sandbox_resource_links.py BUILD_FILTER_TRIE FILTER_TRIE`
download_resource "$filter_trie_links" "filter.trie" >> $LOG_DIR/webmaster-geo-daemon.rsync.log 2>&1
