#include <util/datetime/base.h>

#include "config.h"

namespace NWebmaster {

const TString TConfig::MSG_APPLICATION_NAME = "webmaster-validator-daemon";
const TString TConfig::MSG_APPLICATION_VERSION = TConfig::GetProgramRevision();

TConfig::TConfig(NLastGetopt::TOpts &opts)
    : Opts(opts)
{
    opts.AddLongOption("validator.daemon.http.server.port", "bind port")
        .StoreResult(&HTTP_SERVER_PORT)
        .OptionalArgument("<int>")
        .DefaultValue(nullptr);
}

void TConfig::Load() {
    TConfigBase::Load();
}

} //namespace NWebmaster
