#pragma once

#include <wmconsole/proto/stubs.pb.h>
#include <wmconsole/version3/protos/sitemap.pb.h>
#include <wmconsole/version3/wmcutil/http_server.h>

#include <robot/library/sitemap/processor/parser.h>

#include <yweb/robot/filter/robots_filter.h>

#include "config.h"
#include "monitor.h"

namespace NWebmaster {

struct TRobotsTxtParserWrapper {
    TRobotsTxtParserWrapper(const TString &robotsTxt);

    TString ConvertRule(const char *rule) const;
    TVector<int> GetAcceptedLines() const;
    TVector<wmc::stubs::error_info> GetErrors() const;
    wmc::stubs::allow_info IsAllowed(const TString &url) const;
    wmc::stubs::format_error_type ToProtoEnum(EFormatErrorType type) const;

public:
    TRobotsHostInfo::TRobotsTxtPtr Handler;
    THolder<TRobotsHostInfo> Filter;
};

struct TSitemapErrorHandler : public NRobotSitemaps::IErrorHandler {
    TSitemapErrorHandler(proto::sitemap::SitemapInfo &result);
    void Error(int code, int line, const char *str) override;

public:
    proto::sitemap::SitemapInfo &Result;
};

struct TSitemapsUrlsHandler {
    TSitemapsUrlsHandler(proto::sitemap::SitemapInfo &result, TSitemapErrorHandler &errorsHandler);
    void Visit(const NRobotSitemaps::NParser::TUrl &url);

public:
    proto::sitemap::SitemapInfo &Result;
    TSitemapErrorHandler &ErrorsHandler;
    static const int MAX_URLS_COUNT = 50000;
};

struct TValidatorService : THttpServer::TUserService {
    TValidatorService(const TConfig &config);
    bool MethodAnalyzeRobotsRequest(THttpServer::TRequest &request);
    bool MethodAnalyzeSitemapsRequest(THttpServer::TRequest &request);
    bool MethodTurboAnalyzeAdFox(THttpServer::TRequest &request);
    bool MethodPing(THttpServer::TRequest &request);

public:
    const TConfig &Config;

private:
    TMonitor &Monitor;
};

} //namespace NWebmaster
