#include <openssl/hmac.h>

#include <library/cpp/xml/document/xml-document.h>
#include <util/string/hex.h>
#include <util/string/printf.h>

#include <wmconsole/version3/wmcutil/http_client.h>

#include "auth.h"

namespace NWebmaster {

TBlackBox::TBlackBox(const TString &url)
    : Url(url)
{
}

bool TBlackBox::GetUserId(const TString &sessionId, const TString &cookieHost, const TString &remoteIp, TString &result) try {
    TString response = HttpGet<TString>(Sprintf("%s&sessionid=%s&userip=%s&host=%s", Url.data(), sessionId.data(), remoteIp.data(), cookieHost.data()), 5000);

    NXml::TDocument xml(response, NXml::TDocument::String);
    NXml::TConstNode node = xml.Root().Node("uid");
    //key = node.Attr<TString>("");
    result = node.Value<TString>();
    return true;
} catch(std::exception &e) {
    result = e.what();
    return false;
}


} //namespace NWebmaster
